// pages/about.tsx
import Head from "next/head";
import { Box, Container, Typography, Grid } from "@mui/material";
import Header from "../components/landingpagecomponent/header";
import Footer from "../components/landingpagecomponent/footer";
import Image from "next/image";
import AboutImage from "@/public/images/Copilot_20250629_071913.png"; // Replace with your actual image

import { FadeInUp, StaggerContainer } from "../components/AnimatedSections";

export default function About() {
  //   const theme = useTheme();

  const aboutContent = [
    {
      title: "🌍 Our Vision",
      text: "To be Nigeria's most accessible VTU platform, enabling digital inclusion through simplified services and business opportunities.",
    },
    {
      title: "💡 Our Mission",
      text: "To provide fast, secure, and affordable VTU services that empower our customers to generate income and improve their financial well-being.",
    },
    {
      title: "🔒 Our Values",
      text: "Trust, reliability, and customer satisfaction are at the core of everything we do.",
    },
    {
      title: "🚀 Our Promise",
      text: "Instant transactions, competitive rates, and 24/7 customer support.",
    },
  ];

  return (
    <>
      <Head>
        <title>About Us | SABAMUENT VTU Nigeria</title>
        <meta
          name="description"
          content="Learn about SABAMU ENTERPRICE, a reliable VTU business in Nigeria offering affordable and secure digital services."
        />
        <meta
          name="keywords"
          content="About SABAMUENT, VTU business Nigeria, trusted VTU, SABAMU ENTERPRICE, data recharge, airtime Nigeria"
        />
      </Head>

      <Header />

      <Box component="main" sx={{ bgcolor: "#fff", py: 8 }}>
        <Container maxWidth="lg">
          <StaggerContainer>
            <Grid container spacing={6} alignItems="center">
              <Grid size={{ xs: 12, md: 6 }}>
                <FadeInUp>
                  <Typography
                    variant="h3"
                    gutterBottom
                    sx={{ fontWeight: 700 }}
                  >
                    About SABAMU ENTERPRICE
                  </Typography>
                </FadeInUp>

                <FadeInUp delay={0.2}>
                  <Typography variant="body1" paragraph sx={{ mb: 3 }}>
                    SABAMU ENTERPRICE (SABAMUENT) is a trusted and affordable
                    Virtual Top-Up (VTU) provider headquartered in Nigeria. We
                    offer seamless access to airtime recharge, mobile data,
                    electricity bill payment, and cable TV subscription services
                    nationwide.
                  </Typography>
                </FadeInUp>

                <FadeInUp delay={0.3}>
                  <Typography variant="body1" paragraph sx={{ mb: 4 }}>
                    Our mission is to empower everyday Nigerians—entrepreneurs,
                    small business owners, and individuals—with a reliable
                    platform to earn money by reselling essential services. With
                    a focus on reliability, customer support, and transparency,
                    we have built a platform that meets the needs of both new
                    and experienced resellers.
                  </Typography>
                </FadeInUp>
              </Grid>

              <Grid size={{ xs: 12, md: 6 }}>
                <FadeInUp delay={0.4}>
                  <Box
                    sx={{
                      position: "relative",
                      borderRadius: 2,
                      overflow: "hidden",
                      boxShadow: 3,
                      height: { xs: 300, md: 400 },
                      "&:hover": {
                        transform: "scale(1.02)",
                        transition: "transform 0.3s ease",
                      },
                    }}
                  >
                    <Image
                      src={AboutImage}
                      alt="SABAMUENT Team"
                      fill
                      priority
                      sizes="(max-width: 600px) 100vw, (max-width: 960px) 50vw, 33vw"
                      className="about-image"
                      style={{
                        objectFit: "contain",
                      }}
                      quality={90}
                    />
                  </Box>
                </FadeInUp>
              </Grid>
            </Grid>

            <Grid container spacing={4} mt={6}>
              {aboutContent.map((item, index) => (
                <Grid size={{ xs: 12, sm: 6 }} key={index}>
                  <FadeInUp delay={0.1 * index}>
                    <Box
                      sx={{
                        bgcolor: "background.paper",
                        p: 3,
                        borderRadius: 2,
                        height: "100%",
                        boxShadow: 1,
                        transition: "all 0.3s ease",
                        "&:hover": {
                          boxShadow: 3,
                          transform: "translateY(-5px)",
                        },
                      }}
                    >
                      <Typography
                        variant="h6"
                        gutterBottom
                        sx={{ fontWeight: 600 }}
                      >
                        {item.title}
                      </Typography>
                      <Typography variant="body2">{item.text}</Typography>
                    </Box>
                  </FadeInUp>
                </Grid>
              ))}
            </Grid>
          </StaggerContainer>
        </Container>
      </Box>

      <Footer />
    </>
  );
}
