"use client";
import React from "react";
import { useState } from "react";
import SendBulkSMS from "./sendSms";
import NotificationForm from "./notification";

const Notifications = () => {
  const [currentSection, setCurrentSection] = useState("Users Details");

  const renderSection = () => {
    switch (currentSection) {
      case "Notification":
        return <NotificationForm />;
      case "Send SMS to User(s)":
        return <SendBulkSMS />;
      default:
        return <NotificationForm />;
    }
  };

  return (
    <div className="tab">
      <div className="tab-navigation">
        <button
          className={`tablinks ${
            currentSection === "Notify User(s)" ? "active" : ""
          }`}
          onClick={() => setCurrentSection("Notify User(s)")}
        >
          Notify User(s)
        </button>
        <button
          className={`tablinks ${
            currentSection === "Send SMS to User(s)" ? "active" : ""
          }`}
          onClick={() => setCurrentSection("Send SMS to User(s)")}
        >
          Send SMS to User(s)
        </button>
      </div>

      <div className="tabcontent">{renderSection()}</div>

      <style jsx>{`
        .tab {
          display: flex;
          flex-direction: column;
          align-items: stretch;
        }

        .tab-navigation {
          display: flex;
          border-bottom: 1px solid #ccc;
          margin-bottom: 16px;
        }

        .tablinks {
          flex: 1;
          padding: 14px 16px;
          background-color: #f1f1f1;
          border: none;
          outline: none;
          cursor: pointer;
          text-align: center;
          transition: background-color 0.3s;
        }

        .tablinks.active {
          background-color: #007bff;
          color: white;
        }

        .tabcontent {
          padding: 16px;
          animation: fadeEffect 1s;
        }

        @keyframes fadeEffect {
          from {
            opacity: 0;
          }
          to {
            opacity: 1;
          }
        }
      `}</style>
    </div>
  );
};

export default Notifications;
