"use client";
import { useState } from "react";
import { Box, Button, Tabs, Tab, styled } from "@mui/material";
import UsersPage from "@/app/components/users";
import UserRoleUpdate from "./userrolesupdate";
import AuserTransaction from "./auserTransaction";

const StyledTab = styled(Tab)(({ theme }) => ({
  textTransform: "none",
  fontWeight: theme.typography.fontWeightRegular,
  fontSize: theme.typography.pxToRem(15),
  marginRight: theme.spacing(1),
  "&.Mui-selected": {
    color: "#fff",
    backgroundColor: theme.palette.primary.main,
  },
}));

const UserManagement: React.FC = () => {
  const [currentSection, setCurrentSection] = useState("Users Details");

  const handleChange = (event: React.SyntheticEvent, newValue: string) => {
    setCurrentSection(newValue);
  };

  const renderSection = () => {
    switch (currentSection) {
      case "Users Details":
        return <UsersPage />;
      case "Manage User Role":
        return <UserRoleUpdate />;
      case "View A User Transactions":
        return <AuserTransaction />;
      default:
        return null;
    }
  };

  return (
    <Box sx={{ width: "100%" }}>
      <Box sx={{ borderBottom: 1, borderColor: "divider" }}>
        <Tabs
          value={currentSection}
          onChange={handleChange}
          aria-label="user management tabs"
          variant="fullWidth"
        >
          <StyledTab label="Users Details" value="Users Details" />
          <StyledTab label="Manage User Role" value="Manage User Role" />
          <StyledTab
            label="View A User Transactions"
            value="View A User Transactions"
          />
        </Tabs>
      </Box>
      <Box sx={{ p: 3 }}>{renderSection()}</Box>
    </Box>
  );
};

export default UserManagement;
