// pages/api/wallet/search-users.ts
import { NextRequest, NextResponse } from "next/server";
import { User } from "@/models/user";
import { authOptions } from "@/auth";
import { getServerSession } from "next-auth";

export async function POST(req: NextRequest) {
  try {
    const session = await getServerSession(authOptions);
    if (!session || session.user.role !== "admin") {
      return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
    }
    const { query } = await req.json();

    if (!query) {
      return NextResponse.json(
        { message: "Search query is required" },
        { status: 400 }
      );
    }

    const users = await User.find({
      $or: [
        { name: { $regex: query, $options: "i" } },
        { email: { $regex: query, $options: "i" } },
        { mobileNumber: { $regex: query, $options: "i" } },
        { username: { $regex: query, $options: "i" } },
      ],
      role: "user", // Only search regular users, not admins
    })
      .select("_id name email mobileNumber username accountBalance image")
      .limit(10);

    return NextResponse.json({ users });
  } catch (error) {
    console.error("Search users error:", error);
    return NextResponse.json(
      { message: "Internal server error" },
      { status: 500 }
    );
  }
}
