import { NextRequest, NextResponse } from "next/server";
import { getNotification } from "@/models/notification";
import dbConnect from "@/lib/connectdb";
import { authOptions } from "@/auth";
import { getServerSession } from "next-auth";

export const dynamic = "force-dynamic";

export async function GET(req: NextRequest) {
  const session = await getServerSession(authOptions);
  if (!session) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
  }
  await dbConnect();
  const _id = req.nextUrl.searchParams.get("id");

  if (!_id) {
    return NextResponse.json({
      success: false,
      error: "Missing notification id",
      status: 400,
    });
  }

  try {
    const notification = await getNotification(_id);
    return NextResponse.json({
      success: true,
      data: notification,
      status: 200,
    });
  } catch (error) {
    return NextResponse.json({
      success: false,
      error: "Failed to fetch notification",
      status: 500,
    });
  }
}
