import { NextRequest, NextResponse } from "next/server";
import { getServerSession } from "next-auth";
import { authOptions } from "@/auth";
import { generateReferenceId } from "@/utils/junkfunctions";
import dbConnect from "@/lib/connectdb";
import { AdminSettings, User } from "@/models/user";
import Transaction from "@/models/transactions";

export async function GET(req: NextRequest) {
  try {
    // Get user session
    const session = await getServerSession(authOptions);
    if (!session || !session.user) {
      return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
    }

    // Extract user details
    const customerName = session?.user?.name;
    const customerEmail = session?.user?.email;
    const paymentReference = generateReferenceId();

    return NextResponse.json({
      status: 200,
      customerName,
      customerEmail,
      paymentReference,
    });
  } catch (error) {
    console.error(error);
    return NextResponse.json(
      { error: "Internal Server Error" },
      { status: 500 }
    );
  }
}

export async function POST(req: NextRequest) {
  try {
    const session = await getServerSession(authOptions);
    if (!session || !session.user) {
      return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
    }

    // const body = await req.json();
    // const { amount, paymentReference } = body;

    // await dbConnect();

    // // Fetch the user's current account balance
    // const user = await User.findOne({ _id: session.user.id });
    // if (!user) {
    //   return NextResponse.json(
    //     { message: "If the user exists, they will be handled accordingly." },
    //     { status: 404 }
    //   );
    // }
    // const settings = await AdminSettings.findOne();

    // const fee = (settings.depositFeePercentage / 100) * parseFloat(amount);
    // const fee = (2 / 100) * parseFloat(amount);
    // const netAmount = parseFloat(amount) - fee;

    // Create the funding transaction
    // const funding = new Transaction({
    //   userId: session.user.id,
    //   userEmail: user.email,
    //   type: "AutomaticFunding",
    //   amount: netAmount,
    //   balanceBefore: user.accountBalance,
    //   balanceAfter: user.accountBalance, // No change initially
    //   referenceId: paymentReference, // Use Monnify's reference
    //   refund: false,
    //   fundingType: "Automatic", // Specific to funding transactions
    //   fundingSource: "API",
    //   status: "Pending",
    // });

    // // Save the transaction to the database
    // await funding.save();

    return NextResponse.json({ status: 200 });
  } catch (error) {
    console.error("Error processing payment:", error);
    return NextResponse.json(
      { message: "Internal server error" },
      { status: 500 }
    );
  }
}
