// app/api/pricing/route.ts
import { NextRequest, NextResponse } from "next/server";
import { DataPlan } from "@/models/dataAirtimeUtil";
import dbConnect from "@/lib/connectdb";

export async function GET(req: NextRequest) {
  try {
    await dbConnect();

    // Fetch only available data plans with selected fields
    const dataPlans = await DataPlan.find(
      { available: true },
      {
        network: 1,
        planType: 1,
        planSize: 1,
        smartEarnerPrice: 1,
        description: 1,
        _id: 0,
      }
    ).lean();
    console.log(dataPlans);

    const formattedPlans = dataPlans.map((plan) => ({
      name: `${plan.network} ${plan.planType} (${plan.planSize}GB)`,
      price: `₦${plan.smartEarnerPrice.toLocaleString()}`,
      network: plan.network,
      type: plan.planType,
      size: plan.planSize,
      amount: plan.smartEarnerPrice,
      description: plan.description,
    }));

    return NextResponse.json(formattedPlans);
  } catch (error) {
    console.error("Error fetching pricing:", error);
    return NextResponse.json(
      { error: "Failed to fetch pricing" },
      { status: 500 }
    );
  }
}
