// pages/api/referral/create.ts
import { NextRequest, NextResponse } from "next/server";
import { getServerSession } from "next-auth";
import { authOptions } from "@/auth"; // Ensure this path correctly points to your auth options
import dbConnect from "@/lib/connectdb";
import { User } from "@/models/user";

export async function GET(req: NextRequest) {
  const session = await getServerSession(authOptions);

  if (!session) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
  }

  await dbConnect();

  const user = await User.findOne({ email: session.user?.email });

  if (!user) {
    return NextResponse.json(
      { error: "If the user exists, they will be handled accordingly." },
      { status: 404 }
    );
  }

  // Generate referral link
  const referralLink = `${user.referralCode}`;

  return NextResponse.json({ referralLink }, { status: 200 });
}
