import { NextRequest, NextResponse } from "next/server";
import dbConnect from "@/lib/connectdb";
import Transaction from "@/models/transactions";
import { getServerSession } from "next-auth";
import { authOptions } from "@/auth";

export async function GET(req: NextRequest) {
  await dbConnect();

  try {
    const session = await getServerSession(authOptions);
    if (!session) {
      return NextResponse.json({ message: "Unauthorized" }, { status: 401 });
    }

    const userId = session.user.id;
    const userRole = session.user.role; // Assuming role is stored in session

    let transactions;
    if (userRole === "admin") {
      transactions = await Transaction.find({});
    } else {
      transactions = await Transaction.find({ userId });
    }

    return NextResponse.json(transactions, { status: 200 });
  } catch (error) {
    return NextResponse.json(
      { message: "Error fetching transactions", error },
      { status: 500 }
    );
  }
}
