import { authOptions } from "@/auth";
import dbConnect from "@/lib/connectdb";
import { User } from "@/models/user";
import { getServerSession } from "next-auth";
import { NextRequest, NextResponse } from "next/server";

export const dynamic = "force-dynamic";

export async function GET(req: NextRequest) {
  const username = req.nextUrl.searchParams.get("username");
  const email = req.nextUrl.searchParams.get("email");
  const bvnOrNin = req.nextUrl.searchParams.get("bvnOrNin");
  const mobileNumber = req.nextUrl.searchParams.get("mobileNumber");
  await dbConnect();

  let filterUser = {};
  if (username) {
    filterUser = { username };
  } else if (email) {
    filterUser = { email };
  } else if (bvnOrNin) {
    filterUser = { bvnOrNin };
  } else if (mobileNumber) {
    filterUser = { mobileNumber };
  }

  try {
    const session = await getServerSession(authOptions);
    if (!session) {
      return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
    }
    const user = await User.findOne(filterUser).lean();

    if (!user) {
      return NextResponse.json(
        {
          success: false,
          message: "If the user exists, they will be handled accordingly.",
        },
        { status: 404 }
      );
    }
    return NextResponse.json({ success: true });
  } catch (error) {
    return NextResponse.json({ success: false, error: error }, { status: 500 });
  }
}
