import dbConnect from "@/lib/connectdb";
import { User } from "@/models/user";
import { NextRequest, NextResponse } from "next/server";
import { getServerSession } from "next-auth";
import { authOptions } from "@/auth";

export const dynamic = "force-dynamic";
export async function DELETE(req: NextRequest) {
  const _id = req.nextUrl.searchParams.get("id");
  await dbConnect();

  let filterUser = {};
  if (_id) {
    filterUser = { _id: new Object(_id) };
  } else {
    const session = await getServerSession(authOptions);
    if (!session) {
      return NextResponse.json(
        { success: false, message: "Unauthorized" },
        { status: 401 }
      );
    }
    const email = session?.user?.email;
    if (!email) {
      return Response.json(
        { success: false, message: "User Email not Found" },
        { status: 401 }
      );
    }
    filterUser = { email };
  }

  try {
    const session = await getServerSession(authOptions);
    if (!session || session.user.role !== "admin") {
      return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
    }
    const deletedUser = await User.deleteOne(filterUser);
    if (!deletedUser) {
      return NextResponse.json(
        {
          success: false,
          message: "If the user exists, they will be handled accordingly.",
        },
        { status: 404 }
      );
    }
    return NextResponse.json({ success: true });
  } catch (error) {
    return NextResponse.json({ success: false, error: error }, { status: 400 });
  }
}
