// import { authOptions } from "@/auth";
// import { getServerSession } from "next-auth/next";
// import dbConnect from "@/lib/connectdb";
// import { User } from "@/models/user";
// import { NextRequest, NextResponse } from "next/server";

// export const dynamic = "force-dynamic";
// export async function GET(req: NextRequest) {
//   await dbConnect();

//   let filterUser = {};

//   const session = await getServerSession(authOptions);
//   if (!session) {
//     return NextResponse.json(
//       { success: false, message: "Unauthorized" },
//       { status: 401 }
//     );
//   }
//   const email = session?.user?.email;
//   if (!email) {
//     return Response.json(
//       { success: false, message: "User Email not Found" },
//       { status: 401 }
//     );
//   }
//   filterUser = { email };

//   try {
//     const user = await User.findOne(filterUser).lean();

//     if (!user) {
//       return NextResponse.json(
//         {
//           success: false,
//           message: "If the user exists, they will be handled accordingly.",
//         },
//         { status: 404 }
//       );
//     }
//     return NextResponse.json(user, { status: 200 });
//   } catch (error) {
//     return NextResponse.json({ success: false, error: error }, { status: 500 });
//   }
// }
import { authOptions } from "@/auth";
import { getServerSession } from "next-auth/next";
import dbConnect from "@/lib/connectdb";
import { User } from "@/models/user";
import { NextRequest, NextResponse } from "next/server";

// Define a type for the user response to avoid TypeScript errors
interface UserResponse {
  userType?: string;
  _id: any;
  email: string;
  accountBalance?: number;
  transactionStatus?: boolean;
  thumbprintStatus?: boolean;
  firstName?: string;
  middleName?: string;
  lastName?: string;
  username?: string;
  mobileNumber?: string;
  nin?: string;
  bvn?: string;
  image?: string;
}

export const dynamic = "force-dynamic";
export async function GET(req: NextRequest) {
  await dbConnect();

  const session = await getServerSession(authOptions);
  if (!session) {
    return NextResponse.json(
      { success: false, message: "Unauthorized" },
      { status: 401 }
    );
  }

  const email = session?.user?.email;
  if (!email) {
    return NextResponse.json(
      { success: false, message: "User Email not Found" },
      { status: 401 }
    );
  }

  try {
    const user = (await User.findOne({ email })
      .select({
        userType: 1,
        _id: 1,
        email: 1,
        accountBalance: 1,
        transactionStatus: 1,
        thumbprintStatus: 1,
        firstName: 1,
        middleName: 1,
        lastName: 1,
        username: 1,
        mobileNumber: 1,
        nin: 1,
        bvn: 1,
        image: 1,
      })
      .lean()) as unknown as UserResponse;

    if (!user) {
      return NextResponse.json(
        { success: false, message: "User not found" },
        { status: 404 }
      );
    }

    const safeUser = {
      userType: user.userType,
      _id: user._id.toString(),
      email: user.email,
      accountBalance: user.accountBalance,
      transactionStatus: user.transactionStatus,
      thumbprintStatus: user.thumbprintStatus,
      firstName: user.firstName,
      middleName: user.middleName,
      lastName: user.lastName,
      username: user.username,
      mobileNumber: user.mobileNumber,
      nin: user.nin,
      bvn: user.bvn,
      image: user.image,
    };

    return NextResponse.json(safeUser, { status: 200 });
  } catch (error) {
    console.error("Error fetching user:", error);
    return NextResponse.json(
      { success: false, error: "Internal Server Error" },
      { status: 500 }
    );
  }
}
