import dbConnect from "@/lib/connectdb";
import { User } from "@/models/user";
import { NextRequest, NextResponse } from "next/server";
import { getServerSession } from "next-auth";
import { authOptions } from "@/auth";

export const dynamic = "force-dynamic";
export async function GET() {
  const session = await getServerSession(authOptions);
  if (!session) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
  }
  const email = session?.user?.email;

  if (typeof email !== "string") {
    return new NextResponse(JSON.stringify({ message: "Invalid Email" }), {
      status: 400,
    });
  }

  try {
    await dbConnect();
    const user = await User.findOne({ email });
    if (user) {
      return NextResponse.json(
        { success: true, user }, // Include success and userId properties
        { status: 200 }
      );
    } else {
      return NextResponse.json(
        {
          success: true,
          message: "If the user exists, they will be handled accordingly.",
        }, // Include success and userId properties
        { status: 404 }
      );
    }
  } catch (error) {
    return NextResponse.json(
      { success: false, error: error }, // Include success and userId properties
      { status: 500 }
    );
  }
}
