import { NextRequest, NextResponse } from "next/server";
import { purchaseDataSubscription } from "@/utils/vtpass";
import { generateReferenceId, generateRequestId } from "@/utils/junkfunctions";
import {
  createTransaction,
  updateTransactionStatus,
} from "@/utils/transactions";
import { getServerSession } from "next-auth";
import { authOptions } from "@/auth";
import { User } from "@/models/user";

export async function POST(req: NextRequest) {
  try {
    const session = await getServerSession(authOptions);
    if (!session) {
      return NextResponse.json({ message: "Unauthorized" }, { status: 401 });
    }

    const { network, variation_code, phone, amount, userId, userEmail } =
      await req.json();
    console.log(network);
    console.log(variation_code);
    console.log(phone);
    const serviceID = `${network.toLowerCase()}-data`;
    const request_id = await generateRequestId();
    const type = "DataTransaction";
    const referenceId = await generateReferenceId();

    let newAmount = amount;
    newAmount = amount - (2 / 100) * amount;

    const user = await User.findOne({ email: session.user.email });
    if (user.accountBalance >= amount) {
      const DataTransaction = {
        userId,
        userEmail,
        type,
        amount: newAmount,
        referenceId,
        refund: false,
        status: "Pending",
        mobileNumber: phone,
        network,
        variation_code,
        discoName: "",
      };

      const transaction = await createTransaction(DataTransaction);

      const result = await purchaseDataSubscription({
        request_id,
        serviceID,
        billersCode: phone, // most networks use phone as billersCode
        variation_code,
        phone,
        amount,
      });

      if (
        result.code === "000" &&
        result.content.transactions.status === "delivered"
      ) {
        transaction.status = "Successful";
      } else if (
        result.code === "000" &&
        result.content.transactions.status === "pending"
      ) {
        transaction.status = "Pending";
      } else if (
        result.code === "016" &&
        result.content.transactions.status === "failed"
      ) {
        transaction.status = "Failed";
      }
      console.log(result);

      const response = result;
      await updateTransactionStatus(
        referenceId,
        type,
        transaction.status,
        newAmount,
        transaction.token || ""
      );

      return NextResponse.json(response, { status: 200 });
    } else {
      return NextResponse.json(
        { message: "Insufficient Balance" },
        { status: 401 }
      );
    }
  } catch (error) {
    console.error("Data purchase error:", error);
    return NextResponse.json(
      { error: "Failed to process data subscription" },
      { status: 500 }
    );
  }
}
