"use client";
import { useSession } from "next-auth/react";
import { useRouter } from "next/navigation";
import { SignInPage } from "./signin";
import LoadingComponent from "@/app/components/loadingcomponent";
import { useEffect } from "react";

const SignIn: React.FC = () => {
  const { data: session, status } = useSession();
  const router = useRouter();

  useEffect(() => {
    if (status === "authenticated") {
      router.push("/dashboard");
    }
  }, [status, router]);

  if (status === "loading") {
    return (
      <div className="flex items-center justify-center min-h-screen">
        <LoadingComponent />
      </div>
    );
  }

  if (status === "authenticated") {
    return (
      <div className="flex items-center justify-center min-h-screen">
        <LoadingComponent />
      </div>
    );
  }

  // Unauthenticated: Show Sign In UI with possible error
  return <SignInPage />;
};

export default SignIn;
