// components/AnimatedAccordion.tsx
"use client";

import {
  Accordion,
  AccordionDetails,
  AccordionSummary,
  Typography,
} from "@mui/material";
import ExpandMoreIcon from "@mui/icons-material/ExpandMore";
import { FadeInItem } from "./AnimatedSections";

export const AnimatedAccordion = ({
  question,
  answer,
  index,
}: {
  question: string;
  answer: string;
  index: number;
}) => (
  <FadeInItem delay={index * 0.1}>
    <Accordion
      sx={{
        mb: 2,
        boxShadow:
          "0px 2px 1px -1px rgba(0,0,0,0.2), 0px 1px 1px 0px rgba(0,0,0,0.14), 0px 1px 3px 0px rgba(0,0,0,0.12)",
        "&:hover": {
          boxShadow:
            "0px 3px 5px -1px rgba(0,0,0,0.2), 0px 5px 8px 0px rgba(0,0,0,0.14), 0px 1px 14px 0px rgba(0,0,0,0.12)",
        },
        transition: "box-shadow 0.3s ease-in-out",
      }}
    >
      <AccordionSummary expandIcon={<ExpandMoreIcon />}>
        <Typography variant="subtitle1" sx={{ fontWeight: 600 }}>
          {question}
        </Typography>
      </AccordionSummary>
      <AccordionDetails>
        <Typography variant="body2">{answer}</Typography>
      </AccordionDetails>
    </Accordion>
  </FadeInItem>
);
