// components/Footer.tsx
import {
  Box,
  Container,
  Grid,
  Typography,
  Link,
  Divider,
  IconButton,
} from "@mui/material";
import Image from "next/image";
import {
  Phone,
  Email,
  LocationOn,
  Facebook,
  Twitter,
  Instagram,
  LinkedIn,
} from "@mui/icons-material";
import Logo from "../../../public/images/sabamuent3d.png";

const Footer = () => {
  return (
    <Box
      component="footer"
      sx={{
        backgroundColor: "default",
        color: "inherit",
        py: 6,
      }}
    >
      <Container maxWidth="lg">
        <Grid container spacing={4}>
          {/* About Section */}
          <Grid size={{ xs: 12, md: 4 }}>
            <Box
              sx={{
                display: "flex",
                flexDirection: "column",
                alignItems: { xs: "center", md: "flex-start" },
                textAlign: { xs: "center", md: "left" },
              }}
            >
              <Image
                src={Logo} // Replace with your actual logo path
                alt="SABAMUENT Logo"
                width={100}
                height={100}
                style={{ marginBottom: 16 }}
              />
              <Typography variant="body1" paragraph>
                Here at SABAMUENT, we offer you the most affordable and cheapest
                data, airtime, Dstv, Gotv and Startimes subscription.
              </Typography>
            </Box>
          </Grid>
          {/* Logo in the middle (only on desktop) */}
          <Grid
            size={{ md: 4 }}
            sx={{
              display: { xs: "none", md: "flex" },
              justifyContent: "center",
              alignItems: "center",
            }}
          >
            <Image
              src={Logo} // Replace with your actual logo path
              alt="SABAMUENT Logo"
              width={150}
              height={150}
            />
          </Grid>
          {/* Services and Quick Links Section */}
          <Grid size={{ xs: 12, md: 4 }}>
            <Grid container spacing={2}>
              <Grid size={{ xs: 6 }}>
                <Typography variant="h6" gutterBottom>
                  Our Services
                </Typography>
                <Box
                  component="ul"
                  sx={{ listStyle: "none", pl: 0, mb: 2, mt: 0 }}
                >
                  <li>
                    <Link
                      href="/auth/sign-in"
                      color="inherit"
                      underline="hover"
                    >
                      Buy Data
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/auth/sign-in"
                      color="inherit"
                      underline="hover"
                    >
                      Airtime Top Up
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/auth/sign-in"
                      color="inherit"
                      underline="hover"
                    >
                      Cable Subscription
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/auth/sign-in"
                      color="inherit"
                      underline="hover"
                    >
                      Electricity Payment
                    </Link>
                  </li>
                </Box>
              </Grid>

              <Grid size={{ xs: 6 }}>
                <Typography variant="h6" gutterBottom>
                  Quick Links
                </Typography>
                <Box
                  component="ul"
                  sx={{ listStyle: "none", pl: 0, mb: 2, mt: 0 }}
                >
                  <li>
                    <Link
                      href="vtu-services-in-nigeria"
                      color="inherit"
                      underline="hover"
                    >
                      Our Services
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/about-sabamuent-vtu-business"
                      color="inherit"
                      underline="hover"
                    >
                      About Us
                    </Link>
                  </li>
                  <li>
                    <Link href="/" color="inherit" underline="hover">
                      Home
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="contact-sabamu-enterprice"
                      color="inherit"
                      underline="hover"
                    >
                      Contact
                    </Link>
                  </li>
                  <li>
                    <Link href="/auth/login" color="inherit" underline="hover">
                      Login
                    </Link>
                  </li>
                  <li>
                    <Link href="/privacy" color="inherit" underline="hover">
                      Privacy Policy
                    </Link>
                  </li>
                  <li>
                    <Link href="/terms" color="inherit" underline="hover">
                      Terms
                    </Link>
                  </li>
                </Box>
              </Grid>
            </Grid>
          </Grid>
        </Grid>

        <Divider sx={{ my: 4, backgroundColor: "rgba(255,255,255,0.2)" }} />

        {/* Contact Information */}
        <Grid container spacing={2}>
          <Grid size={{ xs: 12, md: 4 }}>
            <Box
              sx={{
                display: "flex",
                alignItems: "center",
                mb: 1,
                justifyContent: { xs: "center", md: "flex-start" },
              }}
            >
              <Phone sx={{ mr: 1 }} />
              <Typography>
                <Link href="tel:07068529363" color="inherit" underline="hover">
                  07068529363
                </Link>
                ,{" "}
                <Link href="tel:08162552901" color="inherit" underline="hover">
                  08162552901
                </Link>
              </Typography>
            </Box>
          </Grid>

          <Grid size={{ xs: 12, md: 4 }}>
            <Box
              sx={{
                display: "flex",
                alignItems: "center",
                mb: 1,
                justifyContent: "center",
              }}
            >
              <Email sx={{ mr: 1 }} />
              <Link
                href="mailto:triplemultipurposetechnology@gmail.com"
                color="inherit"
                underline="hover"
              >
                triplemultipurposetechnology@gmail.com
              </Link>
            </Box>
          </Grid>

          <Grid size={{ xs: 12, md: 4 }}>
            <Box
              sx={{
                display: "flex",
                alignItems: "center",
                justifyContent: { xs: "center", md: "flex-end" },
              }}
            >
              <LocationOn sx={{ mr: 1 }} />
              <Typography>
                No. H11 Baba Musami Plaza Post Office, Maiduguri, Borno State
              </Typography>
            </Box>
          </Grid>
        </Grid>

        {/* Social Media and Copyright */}
        <Box
          sx={{
            display: "flex",
            flexDirection: "column",
            alignItems: "center",
            mt: 4,
          }}
        >
          <Box sx={{ mb: 2 }}>
            <IconButton href="#" color="inherit">
              <Facebook />
            </IconButton>
            <IconButton href="#" color="inherit">
              <Twitter />
            </IconButton>
            <IconButton href="#" color="inherit">
              <Instagram />
            </IconButton>
            <IconButton href="#" color="inherit">
              <LinkedIn />
            </IconButton>
          </Box>
          <Typography variant="body2">
            Copyright © {new Date().getFullYear()} SABAMUENT. Designed By TRIPLE
            MULTIPURPOSE TECHNOLOGY
          </Typography>
        </Box>
      </Container>
    </Box>
  );
};

export default Footer;
