// components/Header.tsx
"use client";
import {
  AppBar,
  Toolbar,
  Typography,
  Button,
  Box,
  Container,
  IconButton,
  Menu,
  MenuItem,
  useMediaQuery,
  useTheme,
} from "@mui/material";
import Link from "next/link";
import Image from "next/image";
import MenuIcon from "@mui/icons-material/Menu";
import AccountCircle from "@mui/icons-material/AccountCircle";
import InfoIcon from "@mui/icons-material/Info";
import DesignServicesIcon from "@mui/icons-material/DesignServices";
import AttachMoneyIcon from "@mui/icons-material/AttachMoney";
import ContactMailIcon from "@mui/icons-material/ContactMail";
import { useState } from "react";
import Logo from "../../../public/images/sabamuent3d.png";

const Header = () => {
  const theme = useTheme();
  const isMobile = useMediaQuery(theme.breakpoints.down("md"));
  const [anchorEl, setAnchorEl] = useState<null | HTMLElement>(null);
  const open = Boolean(anchorEl);

  const handleMenuOpen = (event: React.MouseEvent<HTMLButtonElement>) => {
    setAnchorEl(event.currentTarget);
  };

  const handleMenuClose = () => {
    setAnchorEl(null);
  };

  return (
    <AppBar position="static" color="default" elevation={1}>
      <Container maxWidth="xl">
        <Toolbar disableGutters sx={{ justifyContent: "space-between" }}>
          {/* Logo and Brand Name */}
          <Box sx={{ display: "flex", alignItems: "center" }}>
            <Link href="/" passHref>
              <Box
                sx={{
                  display: "flex",
                  alignItems: "center",
                  cursor: "pointer",
                }}
              >
                <Image
                  src={Logo} // Replace with your actual logo path
                  alt="SABAMUENT Logo"
                  width={40}
                  height={40}
                  style={{ marginRight: 10 }}
                />
                <Typography
                  variant="h6"
                  component="div"
                  sx={{ fontWeight: "bold" }}
                >
                  SABAMUENT
                </Typography>
              </Box>
            </Link>
          </Box>

          {/* Desktop Navigation */}
          {!isMobile ? (
            <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
              <Button
                href="/about-sabamuent-vtu-business"
                color="inherit"
                startIcon={<InfoIcon />}
              >
                About
              </Button>
              <Button
                href="/vtu-services-in-nigeria"
                color="inherit"
                startIcon={<DesignServicesIcon />}
              >
                Services
              </Button>
              <Button
                href="/vtu-pricing"
                color="inherit"
                startIcon={<AttachMoneyIcon />}
              >
                Pricing
              </Button>
              <Button
                href="/contact-sabamu-enterprice"
                color="inherit"
                startIcon={<ContactMailIcon />}
              >
                Contact
              </Button>
              <Button
                href="/auth/sign-in"
                variant="outlined"
                startIcon={<AccountCircle />}
                sx={{ ml: 2 }}
              >
                Login/Singup
              </Button>
            </Box>
          ) : (
            /* Mobile Navigation */
            <>
              <IconButton
                size="large"
                edge="end"
                color="inherit"
                aria-label="menu"
                onClick={handleMenuOpen}
              >
                <MenuIcon />
              </IconButton>
              <Menu
                anchorEl={anchorEl}
                open={open}
                onClose={handleMenuClose}
                anchorOrigin={{
                  vertical: "top",
                  horizontal: "right",
                }}
                transformOrigin={{
                  vertical: "top",
                  horizontal: "right",
                }}
              >
                <MenuItem
                  onClick={handleMenuClose}
                  component={Link}
                  href="/about-sabamuent-vtu-business"
                >
                  <InfoIcon sx={{ mr: 1 }} /> About
                </MenuItem>
                <MenuItem
                  onClick={handleMenuClose}
                  component={Link}
                  href="/vtu-services-in-nigeria"
                >
                  <DesignServicesIcon sx={{ mr: 1 }} /> Services
                </MenuItem>
                <MenuItem
                  onClick={handleMenuClose}
                  component={Link}
                  href="/vtu-pricing"
                >
                  <AttachMoneyIcon sx={{ mr: 1 }} /> Pricing
                </MenuItem>
                <MenuItem
                  onClick={handleMenuClose}
                  component={Link}
                  href="/contact-sabamu-enterprice"
                >
                  <ContactMailIcon sx={{ mr: 1 }} /> Contact
                </MenuItem>
                <MenuItem
                  onClick={handleMenuClose}
                  component={Link}
                  href="/auth/sign-in"
                >
                  <AccountCircle sx={{ mr: 1 }} /> Login/Signup
                </MenuItem>
              </Menu>
            </>
          )}
        </Toolbar>
      </Container>
    </AppBar>
  );
};

export default Header;
