"use client";

import React from "react";
import { Modal, Box, Typography, Button, Alert } from "@mui/material";
import LoadingComponent from "../loadingcomponent";

interface TransactionModalProps {
  open: boolean;
  onClose: () => void;
  transactionDetails: {
    amount: string;
    recipient: string;
    finalMessage: string;
    status: "success" | "failed" | "pending";
  };
  isLoading?: boolean;
}

const TransactionModal: React.FC<TransactionModalProps> = ({
  open,
  onClose,
  transactionDetails,
  isLoading = false,
}) => {
  const { status, finalMessage } = transactionDetails;

  return (
    <Modal open={open} onClose={onClose}>
      <Box
        sx={{
          position: "absolute",
          top: "50%",
          left: "50%",
          transform: "translate(-50%, -50%)",
          width: 300,
          bgcolor: "background.paper",
          boxShadow: 24,
          p: 4,
          borderRadius: 2,
        }}
      >
        <Typography variant="h6" gutterBottom>
          Transaction {status === "success" ? "Successful" : "Failed"}
        </Typography>

        {/* Transaction Details */}
        <Box sx={{ mb: 3 }}>
          <Typography variant="body1">{finalMessage}</Typography>
        </Box>

        {/* Loading State */}
        {isLoading && (
          <Box sx={{ display: "flex", justifyContent: "center", my: 2 }}>
            <LoadingComponent />
          </Box>
        )}

        {/* Success or Error Message */}
        {status === "success" && (
          <Alert severity="success" sx={{ mb: 2 }}>
            Transaction completed successfully!
          </Alert>
        )}
        {status === "failed" && (
          <Alert severity="error" sx={{ mb: 2 }}>
            Transaction failed. Please try again.
          </Alert>
        )}
        {status === "pending" && (
          <Alert severity="info" sx={{ mb: 2 }}>
            Transaction pending. please check transaction history.
          </Alert>
        )}

        {/* Close Button */}
        <Box sx={{ display: "flex", justifyContent: "flex-end" }}>
          <Button variant="contained" onClick={onClose}>
            Close
          </Button>
        </Box>
      </Box>
    </Modal>
  );
};

export default TransactionModal;
