// pages/contact.tsx
import Head from "next/head";
import {
  Box,
  Button,
  Container,
  Grid,
  TextField,
  Typography,
  Link,
} from "@mui/material";
import Header from "../components/landingpagecomponent/header";
import Footer from "../components/landingpagecomponent/footer";

export default function Contact() {
  return (
    <>
      <Head>
        <title>Contact Us | SABAMUENT</title>
        <meta
          name="description"
          content="Get in touch with SABAMUENT via contact form, WhatsApp or phone. We're here to support your VTU journey."
        />
        <meta
          name="keywords"
          content="contact sabamuent, vtu contact, whatsapp sabamuent, sabamuenterprice, support"
        />
      </Head>

      <Header />

      <Box component="main" sx={{ py: 6 }}>
        <Container maxWidth="md">
          <Typography variant="h4" align="center" gutterBottom>
            Contact Us
          </Typography>
          <Typography variant="body1" align="center" sx={{ mb: 4 }}>
            We'd love to hear from you. Fill out the form or reach out through
            our contact options.
          </Typography>

          <Grid container spacing={4}>
            <Grid size={{ xs: 12, md: 6 }}>
              <form>
                <TextField
                  label="Full Name"
                  fullWidth
                  margin="normal"
                  required
                />
                <TextField
                  label="Email Address"
                  type="email"
                  fullWidth
                  margin="normal"
                  required
                />
                <TextField
                  label="Message"
                  fullWidth
                  multiline
                  rows={4}
                  margin="normal"
                  required
                />
                <Button
                  type="submit"
                  variant="contained"
                  color="primary"
                  sx={{ mt: 2 }}
                >
                  Send Message
                </Button>
              </form>
            </Grid>

            <Grid size={{ xs: 12, md: 6 }}>
              <Box>
                <Typography variant="h6">WhatsApp</Typography>
                <Link
                  href="https://wa.me/2348162552901"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  +234 816 255 2901
                </Link>

                <Typography variant="h6" mt={3}>
                  Phone Support
                </Typography>
                <Typography>+234 816 255 2901</Typography>

                <Typography variant="h6" mt={3}>
                  Email
                </Typography>
                <Typography>support@sabamuent.ng</Typography>
              </Box>
            </Grid>
          </Grid>
        </Container>
      </Box>

      <Footer />
    </>
  );
}
