"use client";

import React, { useState } from "react";
import { Typography, Container, Grid, ToggleButton } from "@mui/material";
import CablePayment from "./CablePayment";
import BillPayment from "./BillPayment";

const utilityTypes = ["Cable Payment", "Bill Payment"];

type UtilityType = "Cable Payment" | "Bill Payment";

const UtilityPayments: React.FC = () => {
  const [selectedUtilityType, setSelectedUtilityType] =
    useState<UtilityType | null>(null);

  return (
    <Container>
      <Typography variant="h4" gutterBottom>
        Utility Payment
      </Typography>

      {/* Select Utility Type */}
      <Typography variant="h6" sx={{ marginBottom: "10px" }}>
        Select Utility Type
      </Typography>
      <Grid container spacing={2}>
        {utilityTypes.map((type) => (
          <Grid sx={{ xs: 6 }} key={type}>
            <ToggleButton
              value={type}
              selected={selectedUtilityType === type}
              onClick={() => setSelectedUtilityType(type as UtilityType)}
              sx={{ width: "100%", height: "50px" }}
            >
              {type}
            </ToggleButton>
          </Grid>
        ))}
      </Grid>

      {/* Render Cable Payment or Bill Payment based on selection */}
      {selectedUtilityType === "Cable Payment" && <CablePayment />}
      {selectedUtilityType === "Bill Payment" && <BillPayment />}
    </Container>
  );
};

export default UtilityPayments;
