// app/not-found.tsx
import { Box, Button, Container, Typography } from "@mui/material";
import Image from "next/image";
import Link from "next/link";
import Logo from "@/public/images/sabamuent3d.png"; // Update with your logo path
import Header from "./components/landingpagecomponent/header";
import Footer from "./components/landingpagecomponent/footer";

export default function NotFound() {
  return (
    <>
      <Header />
      <Container
        maxWidth="sm"
        sx={{
          height: "100vh",
          display: "flex",
          flexDirection: "column",
          justifyContent: "center",
          alignItems: "center",
          textAlign: "center",
          py: 8,
        }}
      >
        {/* Logo */}
        <Box sx={{ mb: 4 }}>
          <Image
            src={Logo}
            alt="SABAMUENT Logo"
            width={180}
            height={180}
            priority
          />
        </Box>

        {/* Error Message */}
        <Typography
          variant="h5"
          component="h3"
          gutterBottom
          sx={{ fontWeight: 700 }}
        >
          404 - Page Not Found
        </Typography>

        <Typography
          variant="body1"
          color="text.secondary"
          sx={{ mb: 4, maxWidth: 500 }}
        >
          The page you're looking for doesn't exist or may have been moved.
        </Typography>

        {/* Action Buttons */}
        <Box
          sx={{
            display: "flex",
            gap: 2,
            flexWrap: "wrap",
            justifyContent: "center",
          }}
        >
          <Button component={Link} href="/" variant="contained" size="large">
            Return Home
          </Button>
          <Button
            component={Link}
            href="/contact-sabamu-enterprice"
            variant="outlined"
            size="large"
          >
            Contact Support
          </Button>
        </Box>
      </Container>
      <Footer />
    </>
  );
}
