// app/page.tsx
import Head from "next/head";
import { Box, Button, Container, Grid, Typography } from "@mui/material";
import Image from "next/image";
import Header from "./components/landingpagecomponent/header";
import Footer from "./components/landingpagecomponent/footer";
import Logo from "@/public/images/Copilot_20250629_071913-removebg-preview.png";
import {
  Bolt,
  Security,
  SupportAgent,
  HowToReg,
  AccountBalanceWallet,
  Paid,
  TrendingUp,
  PriceChange,
} from "@mui/icons-material";
import {
  FadeInItem,
  MotionBox,
  StaggerContainer,
} from "./components/AnimatedSections";
import { AnimatedAccordion } from "./components/AnimatedAccordion";

// Define colors directly
const colors = {
  primary: "#1976d2",
  textSecondary: "rgba(0, 0, 0, 0.6)",
  background: "#f5f5f5",
};

const features = [
  {
    title: "Instant Top-Up",
    desc: "Enjoy fast and reliable airtime and data top-up services anytime, anywhere.",
    icon: <Bolt sx={{ fontSize: 40, color: colors.primary }} />,
  },
  {
    title: "Competitive Pricing",
    desc: "Maximize your profits with low VTU prises on data and other services.",
    icon: <PriceChange sx={{ fontSize: 40, color: colors.primary }} />,
  },
  {
    title: "Secure Transactions",
    desc: "Our platform ensures encrypted, secure wallet funding and disbursement.",
    icon: <Security sx={{ fontSize: 40, color: colors.primary }} />,
  },
  {
    title: "Local Support",
    desc: "We offer support tailored to Nigerian users including WhatsApp access.",
    icon: <SupportAgent sx={{ fontSize: 40, color: colors.primary }} />,
  },
];

const steps = [
  {
    text: "Create a free SABAMUENT account",
    icon: <HowToReg sx={{ fontSize: 40, color: colors.primary }} />,
  },
  {
    text: "Fund your wallet using secure channels",
    icon: <AccountBalanceWallet sx={{ fontSize: 40, color: colors.primary }} />,
  },
  {
    text: "Start recharging airtime, buying data, or paying bills",
    icon: <Paid sx={{ fontSize: 40, color: colors.primary }} />,
  },
  {
    text: "Earn commissions for every transaction",
    icon: <TrendingUp sx={{ fontSize: 40, color: colors.primary }} />,
  },
];
const faqs = [
  {
    q: "Is SABAMUENT free to join?",
    a: "Yes, registration is completely free. You only pay when funding your wallet to use our services.",
  },
  {
    q: "Can I earn money reselling VTU services?",
    a: "Absolutely! You earn commissions on every successful airtime, data, cable, or utility transaction.",
  },
  {
    q: "How fast are transactions processed?",
    a: "Most transactions are completed instantly. Delays, if any, are communicated promptly.",
  },
  {
    q: "Is my payment and data secure?",
    a: "Yes, we use encryption and secure channels to protect all user data and transactions.",
  },
];

const LandingPage = () => {
  return (
    <>
      <Head>
        <title>SABAMUENT | VTU Business in Nigeria</title>
        <meta
          name="description"
          content="Recharge airtime, buy data, pay electricity bills and TV subscriptions with SABAMU ENTERPRISE. Trusted VTU in Nigeria."
        />
        <meta
          name="keywords"
          content="VTU, data reseller, airtime recharge, Nigeria, Data Subscription, SABAMUENT, pay bills, MTN, GLO, Airtel, 9mobile, VTU business in Nigeria, Buy data online Nigeria, Airtime top-up Nigeria, Pay electricity bills online Nigeria, Cable TV subscription Nigeria, Cheapest data plan Nigeria, VTU website in Nigeria, How to start VTU business in Nigeria, VTU reseller platform, Data reselling business in Nigeria, VTU portal Nigeria, Buy airtime online Nigeria, Startimes subscription online, DSTV payment online, GOTV payment portal, MTN data reselling, Airtel data plans Nigeria, Glo airtime top-up, VTU API integration Nigeria, Best VTU platform Nigeria, VTU website builder Nigeria, Electricity bill payment VTU, How to make money from VTU, How to create a VTU website with Next.js, Cheapest VTU platform to resell data in Nigeria, How to print recharge cards in Nigeria 2025, API for VTU business in Nigeria, How to integrate Monnify with VTU website, Set up payment gateway on VTU portal, How much can I earn from VTU business, Profitable side hustle in Nigeria 2025, Buy airtime and data instantly online, Top 10 VTU platforms in Nigeria, Online platform for WAEC ePIN sales, Cable TV and electricity payment website in Nigeria, VTU website Lagos Nigeria, Airtime reseller Abuja, VTU platform Port Harcourt, Resell data plans in Nigeria, Instant airtime recharge portal, Build VTU portal in Nigeria, Online utility payments in Nigeria"
        />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta
          property="og:title"
          content="SABAMUENT | Your Reliable VTU Partner"
        />
        <meta
          property="og:description"
          content="Start your VTU journey with SABAMU ENTERPRISE. Earn from reselling data, airtime, and utilities."
        />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://sabamuent.ng" />
        <meta property="og:image" content="/og-banner.jpg" />
        <link rel="icon" href="/favicon.ico" />
      </Head>

      <Header />

      {/* Hero Section */}
      <Box component="main" sx={{ bgcolor: colors.background, py: 8 }}>
        <Container maxWidth="lg">
          <Grid container spacing={4} alignItems="center">
            <Grid size={{ xs: 12, md: 6 }}>
              <MotionBox>
                <Typography
                  variant="h3"
                  component="h1"
                  gutterBottom
                  sx={{ fontWeight: 700 }}
                >
                  SABAMU ENTERPRISE
                </Typography>
                <Typography
                  variant="h5"
                  color={colors.textSecondary}
                  gutterBottom
                  sx={{ mb: 3 }}
                >
                  Your One-Stop Platform for Airtime, Data, Electricity & Cable
                  Recharges
                </Typography>
                <Typography variant="body1" sx={{ mb: 3 }}>
                  Start earning today by reselling essential services to your
                  customers. Secure, fast, and affordable VTU service tailored
                  for Nigerians.
                </Typography>
                <Button
                  variant="contained"
                  color="primary"
                  size="large"
                  href="/auth/sign-in"
                  sx={{ px: 4, py: 1.5 }}
                >
                  Get Started
                </Button>
              </MotionBox>
            </Grid>
            <Grid size={{ xs: 12, md: 6 }}>
              <MotionBox>
                <Image
                  src={Logo}
                  alt="VTU Services Nigeria"
                  width={500}
                  height={400}
                  style={{
                    maxWidth: "100%",
                    width: "100%", // ✅ Added
                    height: "100%", // ✅ Already present
                    objectFit: "contain",
                  }}
                  priority
                />
              </MotionBox>
            </Grid>
          </Grid>
        </Container>
      </Box>

      {/* Features Section */}
      <Box component="section" sx={{ py: 8, bgcolor: "white" }}>
        <Container>
          <MotionBox>
            <Typography
              variant="h4"
              align="center"
              gutterBottom
              sx={{ fontWeight: 700, mb: 6 }}
            >
              Why Choose SABAMUENT?
            </Typography>
          </MotionBox>
          <Grid container spacing={4}>
            {features.map((item, i) => (
              <Grid size={{ xs: 12, sm: 6, md: 3 }} key={i}>
                <FadeInItem delay={i * 0.1}>
                  <Box
                    sx={
                      {
                        /* feature box styles */
                      }
                    }
                  >
                    {item.icon}
                    <Typography variant="h6">{item.title}</Typography>
                    <Typography variant="body2" color={colors.textSecondary}>
                      {item.desc}
                    </Typography>
                  </Box>
                </FadeInItem>
              </Grid>
            ))}
          </Grid>
        </Container>
      </Box>

      {/* How It Works Section */}
      <Box component="section" sx={{ py: 8, bgcolor: "#f7fafe" }}>
        <Container>
          <MotionBox>
            <Typography
              variant="h4"
              align="center"
              gutterBottom
              sx={{ fontWeight: 700, mb: 6 }}
            >
              How It Works
            </Typography>
          </MotionBox>
          <Grid container spacing={4} justifyContent="center">
            {steps.map((step, index) => (
              <Grid size={{ xs: 12, sm: 6, md: 3 }} key={index}>
                <FadeInItem delay={index * 0.1}>
                  <Box
                    sx={
                      {
                        /* step box styles */
                      }
                    }
                  >
                    <Box
                      sx={
                        {
                          /* number circle */
                        }
                      }
                    >
                      {index + 1}
                    </Box>
                    {step.icon}
                    <Typography>{step.text}</Typography>
                  </Box>
                </FadeInItem>
              </Grid>
            ))}
          </Grid>
        </Container>
      </Box>

      {/* FAQ Section */}
      <Box component="section" sx={{ py: 8, bgcolor: "white" }}>
        <Container maxWidth="md">
          <MotionBox>
            <Typography
              variant="h4"
              align="center"
              gutterBottom
              sx={{ fontWeight: 700, mb: 6 }}
            >
              Frequently Asked Questions
            </Typography>
          </MotionBox>
          <StaggerContainer>
            {faqs.map((faq, i) => (
              <AnimatedAccordion
                key={i}
                question={faq.q}
                answer={faq.a}
                index={i}
              />
            ))}
          </StaggerContainer>
        </Container>
      </Box>

      <Footer />
    </>
  );
};

export default LandingPage;
