// app/privacy/page.tsx
import { Container, Typography, Box, Link } from "@mui/material";
import Head from "next/head";

export default function PrivacyPolicy() {
  return (
    <>
      <Head>
        <title>Privacy Policy | SABAMU ENTERPRISE (SABAMUENT)</title>
        <meta
          name="description"
          content="Learn how Sabamuent collects, uses, and protects your personal information"
        />
      </Head>

      <Container maxWidth="md" sx={{ py: 4 }}>
        <Typography
          variant="h3"
          component="h1"
          gutterBottom
          sx={{ fontWeight: 700 }}
        >
          Privacy Policy
        </Typography>

        <Box sx={{ mb: 4 }}>
          <Typography variant="body1" paragraph>
            Last Updated: {new Date().toLocaleDateString()}
          </Typography>
          <Typography variant="body1" paragraph>
            SABAMU ENTERPRISE (SABAMUENT) ("we," "our," or "us") is committed to
            protecting your privacy. This Privacy Policy explains how we
            collect, use, disclose, and safeguard your information when you use
            our services.
          </Typography>
        </Box>

        {/* Information Collection */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            1. Information We Collect
          </Typography>
          <Typography variant="body1" paragraph>
            We may collect personal information that you voluntarily provide to
            us when you:
          </Typography>
          <Box component="ul" sx={{ pl: 4, mb: 2 }}>
            <li>
              <Typography>Register for an account</Typography>
            </li>
            <li>
              <Typography>Purchase our services</Typography>
            </li>
            <li>
              <Typography>Contact customer support</Typography>
            </li>
            <li>
              <Typography>Participate in surveys or promotions</Typography>
            </li>
          </Box>
          <Typography variant="body1" paragraph>
            The types of information we collect may include:
          </Typography>
          <Box component="ul" sx={{ pl: 4 }}>
            <li>
              <Typography>Name, email address, phone number</Typography>
            </li>
            <li>
              <Typography>Payment and transaction details</Typography>
            </li>
            <li>
              <Typography>Device and usage information</Typography>
            </li>
            <li>
              <Typography>
                NIN and BVN for Virtual Account Purpose as requried by CBN
              </Typography>
            </li>
          </Box>
        </Box>

        {/* Data Usage */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            2. How We Use Your Information
          </Typography>
          <Typography variant="body1" paragraph>
            We use the information we collect to:
          </Typography>
          <Box component="ul" sx={{ pl: 4 }}>
            <li>
              <Typography>Provide and maintain our services</Typography>
            </li>
            <li>
              <Typography>
                Process transactions and send confirmations
              </Typography>
            </li>
            <li>
              <Typography>
                Improve user experience and service quality
              </Typography>
            </li>
            <li>
              <Typography>Communicate about account and services</Typography>
            </li>
            <li>
              <Typography>Prevent fraud and enhance security</Typography>
            </li>
            <li>
              <Typography>Comply with legal obligations</Typography>
            </li>
            <li>
              <Typography>
                Create a virtual account for crediting your wallet
              </Typography>
            </li>
          </Box>
        </Box>

        {/* Data Sharing */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            3. Information Sharing and Disclosure
          </Typography>
          <Typography variant="body1" paragraph>
            We do not sell your personal information. We may share information
            with:
          </Typography>
          <Box component="ul" sx={{ pl: 4, mb: 2 }}>
            <li>
              <Typography>
                Service providers who assist in our operations
              </Typography>
            </li>
            <li>
              <Typography>
                Payment processors for transaction completion
              </Typography>
            </li>
            <li>
              <Typography>Legal authorities when required by law</Typography>
            </li>
          </Box>
          <Typography variant="body1" paragraph>
            Third-party services have their own privacy policies governing data
            use.
          </Typography>
        </Box>

        {/* Data Security */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            4. Data Security
          </Typography>
          <Typography variant="body1" paragraph>
            We implement appropriate technical and organizational measures to
            protect your personal information, including:
          </Typography>
          <Box component="ul" sx={{ pl: 4, mb: 2 }}>
            <li>
              <Typography>SSL encryption for data transmission</Typography>
            </li>
            <li>
              <Typography>Secure storage systems</Typography>
            </li>
            <li>
              <Typography>Access controls and authentication</Typography>
            </li>
          </Box>
          <Typography variant="body1" paragraph>
            While we strive to protect your data, no method of transmission over
            the Internet is 100% secure.
          </Typography>
        </Box>

        {/* User Rights */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            5. Your Rights and Choices
          </Typography>
          <Typography variant="body1" paragraph>
            You have the right to:
          </Typography>
          <Box component="ul" sx={{ pl: 4, mb: 2 }}>
            <li>
              <Typography>Access and request a copy of your data</Typography>
            </li>
            <li>
              <Typography>Correct inaccurate information</Typography>
            </li>
            <li>
              <Typography>Request deletion of your data</Typography>
            </li>
            <li>
              <Typography>Opt-out of marketing communications</Typography>
            </li>
          </Box>
          <Typography variant="body1" paragraph>
            To exercise these rights, please contact us at
            privacy@sabamuent.com.
          </Typography>
        </Box>

        {/* Cookies */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            6. Cookies and Tracking Technologies
          </Typography>
          <Typography variant="body1" paragraph>
            We use cookies and similar technologies to:
          </Typography>
          <Box component="ul" sx={{ pl: 4, mb: 2 }}>
            <li>
              <Typography>Authenticate users and maintain sessions</Typography>
            </li>
            <li>
              <Typography>Analyze service usage and performance</Typography>
            </li>
            <li>
              <Typography>Personalize content and preferences</Typography>
            </li>
          </Box>
          <Typography variant="body1" paragraph>
            You can manage cookie preferences through your browser settings.
          </Typography>
        </Box>

        {/* Policy Updates */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            7. Changes to This Policy
          </Typography>
          <Typography variant="body1" paragraph>
            We may update this Privacy Policy periodically. We will notify you
            of significant changes by posting the new policy on our website with
            an updated effective date.
          </Typography>
        </Box>

        {/* Contact */}
        <Box sx={{ mt: 4, borderTop: "1px solid #eee", pt: 3 }}>
          <Typography variant="h6" gutterBottom>
            Contact Us
          </Typography>
          <Typography variant="body1" paragraph>
            If you have questions about this Privacy Policy, please contact us
            at:
          </Typography>
          <Typography variant="body1" paragraph>
            Email: privacy@sabamuent.com
          </Typography>
          <Typography variant="body1" paragraph>
            Address: Divine Favour House, Adenike Area, Ogbomoso, Oyo State
          </Typography>
        </Box>
      </Container>
    </>
  );
}
