// app/terms/page.tsx
import { Container, Typography, Box, Link } from "@mui/material";
import Head from "next/head";

export default function UserAgreement() {
  return (
    <>
      <Head>
        <title>User Agreement | SABAMU ENTERPRISE</title>
        <meta
          name="description"
          content="Terms of use for SABAMU ENTERPRISE (SABAMUENT) services"
        />
      </Head>

      <Container maxWidth="md" sx={{ py: 4 }}>
        <Typography
          variant="h3"
          component="h1"
          gutterBottom
          sx={{ fontWeight: 700 }}
        >
          SABAMU ENTERPRISE USER AGREEMENT
        </Typography>

        <Box sx={{ mb: 4 }}>
          <Typography variant="body1" paragraph>
            Owners of sabamuent.com
          </Typography>
        </Box>

        {/* Section 1 */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            1. Acceptance of Terms
          </Typography>
          <Typography variant="body1" paragraph>
            SABAMU ENTERPRISE (SABAMUENT) provides a collection of online
            resources, including but not limited to data bundle internet/mobile
            browsing, air time/recharge cards, classified ads, forums, and
            various email services (referred to hereafter as "the Service")
            subject to the following Terms of Use ("TOU"). By using the Service
            in any way, you are agreeing to comply with the TOU.
          </Typography>
          <Typography variant="body1" paragraph>
            Should you object to any term or condition of the TOU, any
            guidelines, or any subsequent modifications thereto or become
            dissatisfied with SABAMU ENTERPRISE (SABAMUENT) in any way, your
            only recourse is to immediately discontinue use of Sabamuent
            Communication Technology.
          </Typography>
          <Typography variant="body1" paragraph>
            SABAMU ENTERPRISE (SABAMUENT) has the right, but is not obligated,
            to strictly enforce the TOU through self-help, community moderation,
            active investigation, litigation and prosecution.
          </Typography>
        </Box>

        {/* Section 2 */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            2. Modifications to This Agreement
          </Typography>
          <Typography variant="body1" paragraph>
            We reserve the right, at our sole discretion, to change, modify or
            otherwise alter these terms and conditions at any time. Such
            modifications shall become effective immediately upon the posting
            thereof. You must review this agreement on a regular basis to keep
            yourself apprised of any changes.
          </Typography>
        </Box>

        {/* Section 3 */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            3. Conduct
          </Typography>
          <Typography variant="body1" paragraph>
            You agree not to:
          </Typography>

          <Box component="ol" sx={{ pl: 4 }}>
            <li>
              <Typography variant="body1" paragraph>
                Create multiple accounts or violate any
                prohibition/restriction/limit placed on accounts on our website
                as this will lead to termination of your account and you will
                forfeit all funds in your account;
              </Typography>
            </li>
            <li>
              <Typography variant="body1" paragraph>
                Contact anyone who has asked not to be contacted, or make
                unsolicited contact with anyone for any commercial purpose;
              </Typography>
            </li>
            <li>
              <Typography variant="body1" paragraph>
                "Stalk" or otherwise harass anyone;
              </Typography>
            </li>
            {/* Continue with all other conduct points */}
            <li>
              <Typography variant="body1" paragraph>
                That employs misleading email addresses, or forged headers or
                otherwise manipulated identifiers in order to disguise the
                origin of Content transmitted through the Service.
              </Typography>
            </li>
          </Box>
        </Box>

        {/* Section 4 */}
        <Box sx={{ mb: 4 }}>
          <Typography
            variant="h5"
            component="h2"
            gutterBottom
            sx={{ fontWeight: 600 }}
          >
            4. No Spam Policy
          </Typography>
          <Typography variant="body1" paragraph>
            You understand and agree that sending unsolicited email
            advertisements to SABAMU ENTERPRISE (SABAMUENT) email addresses or
            through computer systems, which is expressly prohibited by these
            Terms, will use or cause to be used servers located in California.
            Any unauthorized use of SABAMU ENTERPRISE (SABAMUENT) computer
            systems is a violation of these Terms and certain federal and state
            laws. Such violations may subject the sender and his or her agents
            to civil and criminal penalties.
          </Typography>
        </Box>

        {/* Footer */}
        <Box sx={{ mt: 4, borderTop: "1px solid #eee", pt: 3 }}>
          <Typography variant="h6" gutterBottom>
            SABAMU ENTERPRISE (SABAMUENT)
          </Typography>
          <Typography variant="body1">Divine Favour House,</Typography>
          <Typography variant="body1">Adenike Area,</Typography>
          <Typography variant="body1">Ogbomoso, Oyo State</Typography>
          <Typography variant="body2" sx={{ mt: 2 }}>
            Last updated: {new Date().toLocaleDateString()}
          </Typography>
        </Box>
      </Container>
    </>
  );
}
