// pages/pricing.tsx
"use client";
import Head from "next/head";
import { useEffect, useState } from "react";
import {
  Box,
  Container,
  Typography,
  Grid,
  Paper,
  CircularProgress,
} from "@mui/material";
import Header from "../components/landingpagecomponent/header";
import Footer from "../components/landingpagecomponent/footer";

interface ServicePrice {
  name: string;
  price: string;
}

export default function Pricing() {
  const [prices, setPrices] = useState<ServicePrice[]>([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const fetchPrices = async () => {
      try {
        const res = await fetch("/api/pricing");
        const data = await res.json();
        setPrices(data);
      } catch (err) {
        console.error("Failed to fetch prices", err);
      } finally {
        setLoading(false);
      }
    };
    fetchPrices();
  }, []);

  return (
    <>
      <Head>
        <title>VTU Pricing & Plans | SABAMUENT</title>
        <meta
          name="description"
          content="See up-to-date VTU service pricing from SABAMUENT, including airtime, data, and cable subscriptions."
        />
        <meta
          name="keywords"
          content="VTU pricing, VTU plans, SABAMUENT, data recharge rates, cable TV prices, Buy MTN data online, Buy MTN airtime online, MTN data reseller Nigeria, Cheapest MTN data plans, MTN VTU website Nigeria, MTN airtime top-up portal,
Buy Glo data online, Buy Glo airtime online, Glo data reseller Nigeria, Cheapest Glo data plans, Glo VTU website Nigeria, Glo airtime top-up portal,
Buy Airtel data online, Buy Airtel airtime online, Airtel data reseller Nigeria, Cheapest Airtel data plans, Airtel VTU website Nigeria, Airtel airtime top-up portal,
Buy 9mobile data online, Buy 9mobile airtime online, 9mobile data reseller Nigeria, Cheapest 9mobile data plans, 9mobile VTU website Nigeria, 9mobile airtime top-up portal,
MTN SME data reseller, MTN corporate data plans, Share MTN data online, Glo Yakata recharge Nigeria, Airtel SmartRecharge deals,
9mobile data code Nigeria, Glo weekend data bundles, MTN pulse data plan top-up, Airtel unlimited plan VTU Nigeria,
MTN VTU API integration, Glo VTU API integration, Airtel VTU API integration, 9mobile VTU API integration,
Buy MTN SME data in bulk, VTU for Glo reseller platform, Start Airtel data reselling business, Cheapest 9mobile VTU platform in Nigeria,
Print MTN recharge cards, Print Airtel recharge PINs, Print Glo recharge cards in Nigeria, 9mobile recharge card printing software"
        />
      </Head>

      <Header />

      <Box component="main" sx={{ py: 6, bgcolor: "#fff" }}>
        <Container>
          <Typography variant="h3" align="center" gutterBottom>
            Live VTU Pricing
          </Typography>
          <Typography variant="body1" align="center" sx={{ mb: 5 }}>
            View current rates for Airtime, Data Bundles, and Cable
            Subscriptions powered by VTpass.
          </Typography>

          {loading ? (
            <Box
              display="flex"
              justifyContent="center"
              alignItems="center"
              minHeight="200px"
            >
              <CircularProgress />
            </Box>
          ) : (
            <Grid container spacing={4}>
              {prices.map((item, index) => (
                <Grid size={{ xs: 12, sm: 6, md: 4 }} key={index}>
                  <Paper
                    elevation={3}
                    sx={{ p: 3, borderRadius: 2, height: "100%" }}
                  >
                    <Typography variant="h6" gutterBottom>
                      {item.name}
                    </Typography>
                    <Typography variant="h4" color="primary">
                      {item.price}
                    </Typography>
                  </Paper>
                </Grid>
              ))}
            </Grid>
          )}
        </Container>
      </Box>

      <Footer />
    </>
  );
}
