// pages/services.tsx
import Head from "next/head";
import { Box, Container, Typography, Grid } from "@mui/material";
import Header from "../components/landingpagecomponent/header";
import Footer from "../components/landingpagecomponent/footer";
import { FadeInUp, StaggerContainer } from "../components/AnimatedSections";
import {
  PhoneAndroid, // Airtime
  DataUsage, // Data
  Lightbulb, // Electricity
  LiveTv, // Cable TV
  School, // Education
  AccountBalance, // Wallet
} from "@mui/icons-material";

const services = [
  {
    title: "Airtime Recharge",
    description:
      "Top-up airtime instantly for all major Nigerian networks—MTN, Airtel, Glo, and 9mobile. Reliable delivery, always on.",
    icon: <PhoneAndroid fontSize="large" color="primary" />,
    color: "#4CAF50", // Green
  },
  {
    title: "Data Bundles",
    description:
      "Buy and resell affordable mobile data bundles. Enjoy fast provisioning and the best rates for resellers and customers.",
    icon: <DataUsage fontSize="large" color="primary" />,
    color: "#2196F3", // Blue
  },
  {
    title: "Electricity Bills",
    description:
      "Pay electricity bills for major Nigerian DISCOs (IKEDC, EEDC, KEDCO, etc.) quickly and conveniently through your dashboard.",
    icon: <Lightbulb fontSize="large" color="primary" />,
    color: "#FFC107", // Amber
  },
  {
    title: "Cable TV Subscription",
    description:
      "Renew your DSTV, GOTV, and Startimes subscriptions without delay. Support for all packages at standard or reseller pricing.",
    icon: <LiveTv fontSize="large" color="primary" />,
    color: "#E91E63", // Pink
  },
  {
    title: "WAEC/NECO Result Checker",
    description:
      "Purchase education result checker pins for WAEC and NECO with instant delivery to your email or dashboard.",
    icon: <School fontSize="large" color="primary" />,
    color: "#9C27B0", // Purple
  },
  {
    title: "Wallet Funding",
    description:
      "Fund your SABAMUENT wallet via bank transfer, online payment, or automated gateways for uninterrupted service delivery.",
    icon: <AccountBalance fontSize="large" color="primary" />,
    color: "#607D8B", // Blue Grey
  },
];

export default function Services() {
  return (
    <>
      <Head>
        <title>Our VTU Services | SABAMUENT</title>
        <meta
          name="description"
          content="Explore SABAMUENT's VTU services: Airtime, data, electricity, cable TV, and more. Start your reseller journey today!"
        />
        <meta
          name="keywords"
          content="VTU services, airtime recharge, Nigeria, data bundle, electricity bill, cable TV, WAEC checker, VTU business in Lagos, Buy data in Lagos, Airtime top-up Lagos, Pay electricity bills Lagos, Cable TV subscription Lagos,
VTU business in Abuja, Buy data in Abuja, Airtime top-up Abuja, Pay electricity bills Abuja, Cable TV subscription Abuja,
VTU business in Kano, Buy data in Kano, Airtime top-up Kano, Pay electricity bills Kano, Cable TV subscription Kano,
VTU business in Rivers, Buy data in Port Harcourt, Airtime top-up Port Harcourt, Pay electricity bills Port Harcourt, Cable TV subscription Port Harcourt,
VTU business in Oyo, Buy data in Ibadan, Airtime top-up Ibadan, Pay electricity bills Ibadan, Cable TV subscription Ibadan,
VTU business in Ogun, Buy data in Abeokuta, Airtime top-up Abeokuta, Pay electricity bills Abeokuta, Cable TV subscription Abeokuta,
VTU business in Anambra, Buy data in Awka, Airtime top-up Awka, Pay electricity bills Awka, Cable TV subscription Awka,
VTU business in Enugu, Buy data in Enugu, Airtime top-up Enugu, Pay electricity bills Enugu, Cable TV subscription Enugu,
VTU business in Kaduna, Buy data in Kaduna, Airtime top-up Kaduna, Pay electricity bills Kaduna, Cable TV subscription Kaduna,
VTU business in Delta, Buy data in Warri, Airtime top-up Warri, Pay electricity bills Warri, Cable TV subscription Warri,
VTU business in Edo, Buy data in Benin City, Airtime top-up Benin City, Pay electricity bills Benin City, Cable TV subscription Benin City,
VTU business in Kwara, Buy data in Ilorin, Airtime top-up Ilorin, Pay electricity bills Ilorin, Cable TV subscription Ilorin,
VTU business in Osun, Buy data in Osogbo, Airtime top-up Osogbo, Pay electricity bills Osogbo, Cable TV subscription Osogbo,
VTU business in Ekiti, Buy data in Ado-Ekiti, Airtime top-up Ado-Ekiti, Pay electricity bills Ado-Ekiti, Cable TV subscription Ado-Ekiti,
VTU business in Plateau, Buy data in Jos, Airtime top-up Jos, Pay electricity bills Jos, Cable TV subscription Jos,
VTU business in Borno, Buy data in Maiduguri, Airtime top-up Maiduguri, Pay electricity bills Maiduguri, Cable TV subscription Maiduguri,
VTU business in Akwa Ibom, Buy data in Uyo, Airtime top-up Uyo, Pay electricity bills Uyo, Cable TV subscription Uyo,
VTU business in Bayelsa, Buy data in Yenagoa, Airtime top-up Yenagoa, Pay electricity bills Yenagoa, Cable TV subscription Yenagoa,
VTU business in Cross River, Buy data in Calabar, Airtime top-up Calabar, Pay electricity bills Calabar, Cable TV subscription Calabar,
VTU business in Niger State, Buy data in Minna, Airtime top-up Minna, Pay electricity bills Minna, Cable TV subscription Minna"
        />
      </Head>

      <Header />

      <Box component="main" sx={{ py: 8, bgcolor: "#f9f9f9" }}>
        <Container maxWidth="lg">
          <StaggerContainer>
            <FadeInUp>
              <Typography
                variant="h3"
                align="center"
                gutterBottom
                sx={{ fontWeight: 700, mb: 2 }}
              >
                Our Services
              </Typography>
            </FadeInUp>

            <FadeInUp delay={0.2}>
              <Typography
                variant="body1"
                align="center"
                sx={{ mb: 6, maxWidth: 700, mx: "auto" }}
              >
                At SABAMUENT, we offer a wide range of essential VTU services
                designed to make daily life easier and to help our partners
                earn.
              </Typography>
            </FadeInUp>

            <Grid container spacing={4}>
              {services.map((service, index) => (
                <Grid size={{ xs: 12, sm: 6, md: 4 }} key={index}>
                  <FadeInUp delay={0.1 * index}>
                    <Box
                      sx={{
                        p: 3,
                        border: `1px solid`,
                        borderRadius: 2,
                        height: "100%",
                        transition: "all 0.3s ease",
                        "&:hover": {
                          transform: "translateY(-5px)",

                          borderColor: service.color,
                        },
                      }}
                    >
                      <Box
                        sx={{
                          width: 60,
                          height: 60,
                          borderRadius: "50%",
                          bgcolor: `${service.color}20`,
                          display: "flex",
                          alignItems: "center",
                          justifyContent: "center",
                          mb: 2,
                          color: service.color,
                        }}
                      >
                        {service.icon}
                      </Box>
                      <Typography
                        variant="h6"
                        gutterBottom
                        sx={{ fontWeight: 600 }}
                      >
                        {service.title}
                      </Typography>
                      <Typography variant="body2" color="text.secondary">
                        {service.description}
                      </Typography>
                    </Box>
                  </FadeInUp>
                </Grid>
              ))}
            </Grid>
          </StaggerContainer>
        </Container>
      </Box>

      <Footer />
    </>
  );
}
