// app/unauthorized.tsx
import { Box, Button, Container, Typography } from "@mui/material";
import Image from "next/image";
import Link from "next/link";
import Logo from "@/public/images/sabamuent3d.png"; // Your logo path

export default function Unauthorized() {
  return (
    <Container
      maxWidth="sm"
      sx={{
        height: "100vh",
        display: "flex",
        flexDirection: "column",
        justifyContent: "center",
        alignItems: "center",
        textAlign: "center",
        py: 8,
      }}
    >
      {/* Logo */}
      <Box sx={{ mb: 4 }}>
        <Image
          src={Logo}
          alt="SABAMUENT Logo"
          width={150}
          height={150}
          priority
        />
      </Box>

      {/* Error Message */}
      <Typography
        variant="h3"
        component="h5"
        gutterBottom
        sx={{ fontWeight: 700 }}
      >
        401 - Unauthorized
      </Typography>

      <Typography
        variant="body1"
        color="text.secondary"
        sx={{ mb: 4, maxWidth: 500 }}
      >
        You don't have permission to access this page. Please sign in or contact
        your administrator.
      </Typography>

      {/* Action Buttons */}
      <Box
        sx={{
          display: "flex",
          gap: 2,
          flexWrap: "wrap",
          justifyContent: "center",
        }}
      >
        <Button
          component={Link}
          href="/auth/sign-in"
          variant="contained"
          size="large"
        >
          Sign In
        </Button>
        <Button component={Link} href="/" variant="outlined" size="large">
          Return Home
        </Button>
      </Box>
    </Container>
  );
}

export const metadata = {
  title: "Unauthorized Access | SABAMUENT",
  description: "You need proper permissions to access this resource",
};
