import { format } from "date-fns";
import { v4 as uuidv4 } from "uuid";
import { toZonedTime } from "date-fns-tz";

export async function extractPlanDetails(planString: string) {
  console.log("Extracting plan details from:", planString);
  const match = planString.match(/(\d+(?:GB|MB))\s+N(\d+)/);
  if (match) {
    console.log("Match found:", match);
    // Extracting the plan size and amount from the matched groups
    console.log("Plan size:", match[1], "Amount:", match[2]);
    // Return the extracted details as an object
    // Convert the amount to a number
    console.log("Parsed amount:", parseFloat(match[2]));
    // Return the plan size and amount
    console.log("Returning plan details:", {
      plansize: match[1],
      amount: parseFloat(match[2]),
    });
    return { plansize: match[1], amount: parseFloat(match[2]) };
  }

  return { plansize: null, amount: 0 };
}

export async function generateReferenceId(): Promise<string> {
  return "TXN-" + Math.random().toString(36).slice(2, 12).toUpperCase();
}

export async function generateRequestId(): Promise<string> {
  const timeZone = "Africa/Lagos";
  const now = toZonedTime(new Date(), timeZone);
  const timestamp = format(now, "yyyyMMddHHmm");
  const uniqueId = uuidv4().replace(/-/g, "").slice(0, 8);
  return `${timestamp}${uniqueId}`;
}

export async function generateReferralCode(): Promise<string> {
  const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
  let code = "";
  for (let i = 0; i < 8; i++) {
    code += chars.charAt(Math.floor(Math.random() * chars.length));
  }
  return code;
}
