import axios from "axios";

// const VTPASS_API_URL = "https://vtpass.com/api";
const VTPASS_API_URL = "https://vtpass.com/api";
// const API_KEY = process.env.VTPASS_API_KEY; // Ensure this is set in your environment variables
const VTPASS_API_KEY = process.env.VTPASS_API_KEY!; // Ensure this is set in your environment variables
const VTPASS_EMAIL = process.env.VTPASS_EMAIL!;
const VTPASS_PASSWORD = process.env.VTPASS_PASSWORD!;

interface TVSubscriptionVerificationParams {
  billerCode: string;
  serviceId: string;
}

interface ElectricityVerificationParams {
  billerCode: string;
  serviceId: string;
  type: string; // Prepaid or Postpaid
}

interface VerificationResponse {
  status: string;
  message: string;
  data?: any;
}

export const verifyTVSubscription = async (
  params: TVSubscriptionVerificationParams
): Promise<VerificationResponse> => {
  try {
    const response = await axios.post(
      `${VTPASS_API_URL}/merchant-verify`,
      {
        billersCode: params.billerCode,
        serviceID: params.serviceId,
      },
      {
        headers: {
          "api-key": VTPASS_API_KEY,
          Authorization: `Basic ${Buffer.from(
            `${VTPASS_EMAIL}:${VTPASS_PASSWORD}`
          ).toString("base64")}`,
          "Content-Type": "application/json",
        },
      }
    );
    return response.data;
  } catch (error: any) {
    return {
      status: "error",
      message: error.response?.data?.message || "Verification failed",
    };
  }
};

export const verifyElectricity = async (
  params: ElectricityVerificationParams
): Promise<VerificationResponse> => {
  try {
    const response = await axios.post(
      `${VTPASS_API_URL}/merchant-verify`,
      {
        billersCode: params.billerCode,
        serviceID: params.serviceId,
        type: params.type,
      },
      {
        headers: {
          "api-key": VTPASS_API_KEY,
          Authorization: `Basic ${Buffer.from(
            `${VTPASS_EMAIL}:${VTPASS_PASSWORD}`
          ).toString("base64")}`,
          "Content-Type": "application/json",
        },
      }
    );
    return response.data;
  } catch (error: any) {
    return {
      status: "error",
      message: error.response?.data?.message || "Verification failed",
    };
  }
};
